const path = require('path')
const AutoImport = require('unplugin-auto-import/webpack').default

if (process.env.UNI_PLATFORM === 'h5') {
  process.env.UNI_OUTPUT_DIR = path.join(__dirname, 'build')
}
//target: 'http://gyyb.test.gzyzzckj.com',
module.exports = {
  devServer: {
    // 代理配置
    proxy: {
      '/admin': {
        target: 'http://gyyb.test.gzyzzckj.com',
        changeOrigin: true,
        pathRewrite: {
          '^/admin': '/'
        }
      },
			'/api': {
				target: 'https://hd.gywb.cn', // 目标服务器地址
				changeOrigin: true, // 是否改变源地址
				pathRewrite: { '^/api': ''}, // 路径重写
				secure: false, // 如果是 https 接口，需要配置为 false
				logLevel: 'debug'
			}
    }
  },

  transpileDependencies: ['uview-ui'],

  configureWebpack: {
    resolve: {
      alias: {
        '@': path.join(__dirname, 'src')
      }
    },
    plugins: [
      AutoImport({
        imports: [
          {
            'rexma-cli': ['xma']
          }
        ]
      })
    ]
  }
}
