import request from '@/services/request';
const baseurl = process.env.VUE_APP_BASE_URL

// 获取用户信息
export function getXinhuaDecrypt(options = {}) {
  return request.post('https://onemoment.gywb.cn/back/one-visit/one-visit/web/oneVisit/getXinhuaDecrypt', options);
}

// 枚举字典查询
export function enumsQuery(type: string) {
  return request.post(`${baseurl}/back/practice-api/practice-api/dict/enumsQuery?enumsType=` + type, {});
}

// 第三方枚举字典查询
export function thirdDictEnums(type: string) {
  return request.post(`${baseurl}/back/practice-api/practice-api/dict/thirdDictEnums?type=` + type, {});
}

// 区域查询接口
export function getArea() {
  return request.post(`${baseurl}/back/practice-api/practice-api/dict/area`, {});
}

// 个人编号查询以及参保人个人权益服务-参保险种查询
export function insuranceType(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/insurance/insuranceType`, options);
}

// 代缴金额查询
export function amountQuery(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/proxy/amountQuery`, options);
}

// 代缴申请保存接口
export function payApply(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/proxy/payApply`, options);
}

// 个人医保账户代缴记录查询
export function payApplyQuery(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/proxy/payApplyQuery`, options);
}

// 居民缴费进度查询
export function residentPaymentProgress(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/progress/residentPaymentProgress`, options);
  // return request.post('/engine/rest/queryRsdtPsnClctDetlList', options);
}

// 定点药店/医疗机构查询
export function medicalOrgQuery(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/orgAndPharmacy/medicalOrgQuery`, options);
}

// 经办机构信息查询
export function handingAgencyQuery(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/agency/handingAgencyQuery`, options);
}

// 大病医保/年度账单查询
export function queryYearsBill(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/bill/queryYearsBill`, options);
}

// 门诊统筹额度查询
export function outPatientCoordinationQuota(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/quota/outPatientCoordinationQuota`, options);
}

// 慢病认定医院查询
export function chronicDiseaseIdentificationHospital(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/orgAndPharmacy/chronicDiseaseIdentificationHospital`, options);
}

// 增加关系转移进度办理查询
export function transferInformation(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/transfer/information`, options);
}

// 药品目录信息查询
export function drugCatalog(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/drug/catalog`, options);
}

// 查询医疗救助资格
export function medicalAssistance(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/assistance/medicalAssistance`, options);
}

// 已开通门诊统筹药店查询
export function overallPlanningPharmacyQuery(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/orgAndPharmacy/overallPlanningPharmacyQuery`, options);
}

// 职工缴费进度查询
export function paymentProgress(options = {}) {
  return request.post(`${baseurl}/back/practice-api/practice-api/employment/paymentProgress`, options);
}

