function formatNumber(n) {
  let returnN = n;
  returnN = returnN <= 0 ? 0 : returnN;
  return returnN.toString()[1] ? returnN.toString() : `0${returnN.toString()}`;
}

/* 年月日时分秒转化 */
export const formatTime = (date, patttern = 'yyyy-mm-dd') => {
  let returnDate = new Date(date);
  const y = returnDate.getFullYear();
  const m = formatNumber((returnDate.getMonth() + 1));
  const d = formatNumber(returnDate.getDate());
  const hh = formatNumber(returnDate.getHours());
  const mm = formatNumber(returnDate.getMinutes());
  const ss = formatNumber(returnDate.getSeconds());
  if (patttern === 'yyyy-mm-dd hh:mm:ss') {
    returnDate = `${y}-${m}-${d} ${hh}:${mm}:${ss}`;
  } else if (patttern === 'mm-dd hh:mm') {
    returnDate = `${m}-${d} ${hh}:${mm}`;
  } else if (patttern === 'yyyy-mm-dd hh:mm') {
    returnDate = `${y}-${m}-${d} ${hh}:${mm}`;
  } else if (patttern === 'yyyy-mm-dd') {
    returnDate = `${y}-${m}-${d}`;
  } else if (patttern === 'yyyy年mm月dd日') {
    returnDate = `${y}年${m}月${d}日`;
  } else if (patttern === 'hh:mm') {
    returnDate = `${hh}:${mm}`;
  } else if (patttern === 'mm-dd') {
    returnDate = `${m}-${d}`;
  } else if (patttern === 'yyyy年mm月') {
    returnDate = `${y}年${m}月`;
  } else if (patttern === 'yyyy-mm') {
    returnDate = `${y}-${m}`;
  } else if (patttern === 'hh:mm:ss') {
    returnDate = `${hh}:${mm}:${ss}`;
  } 
  return returnDate;
};

// 手机号码验证函数
export const isTel = (tel) => /^1\d{10}$/.test(tel);

// 密码验证函数
export const isPsd = (psd) => /(?=.*[a-z])(?=.*\d)[a-z\d]{6,12}/i.test(psd);

// 身份证号码验证
export const isCardNo = (CardNo) => {
  let card = CardNo;
  const info = {
    y: '1900',
    m: '01',
    d: '01',
    sex: 'male',
    valid: false,
    length: 0,
  };
  const initDate = (length) => {
    info.length = length;
    const a = length === 15 ? 0 : 2; // 15:18
    let temp = '';
    info.y = (a ? '' : '19') + card.substring(6, 8 + a);
    info.m = card.substring(8 + a, 10 + a);
    info.d = card.substring(10 + a, 12 + a);
    info.sex = card.substring(14, 15 + a) % 2 === 0 ? 'female' : 'male';
    temp = new Date(info.y, info.m - 1, info.d);
    return (temp.getFullYear() === info.y * 1)
      && (temp.getMonth() + 1 === info.m * 1)
      && (temp.getDate() === info.d * 1);
  };
  // 18
  if (/^\d{17}[0-9x]$/i.test(card)) {
    if (!initDate(18)) {
      return false;
    }
    card = card.toLowerCase().split('');
    const wi = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];
    const y = '10x98765432'.split('');
    let sum = 0;
    for (let i = 0; i < 17; i += 1) sum += wi[i] * card[i];
    if (!(y[sum % 11] === card.pop().toLowerCase())) {
      return false;
    }
  } else if (/^\d{15}$/.test(card)) {
    if (!initDate(15)) {
      return false;
    }
  } else {
    return false;
  }
  return true;
};

/**
 * url字符串添加参数
 * @param {Object} url 路径地址
 * @param {Object} paramName 参数名
 * @param {Object} replaceWith 参数值
 */
export const addParamToUrl = (url, paramName, replaceWith) => {
  if (replaceWith === undefined || replaceWith === null) {
    replaceWith = '';
  }
  if (url.indexOf(paramName) > -1) {
    const res = eval('/(' + paramName + '=)([^&]*)/gi');
    url = url.replace(res, `${paramName}=${replaceWith}`);
  } else {
    const paraStr = `${paramName}=${replaceWith}`;
    const idx = url.indexOf('?');
    if (idx < 0) {
      url += '?';
    } else if (idx >= 0 && idx != url.length - 1) {
      url += '&';
    }
    url += paraStr;
  }
  return url;
}

export const getKeyValue = (list, code) => {
	const item = getApp().globalData[list].find((item) => item.code == code)
	if (item) {
		return item.name
	} else {
		return code
	}
}

export const getAreaName = (code) => {
	let flag = true;
	let name = ''
	getApp().globalData.areaOptions.forEach((item) => {
		item.subAreas.forEach((items) => {
			if (items.code == code) {
				flag = false
				name = `${item.name}${items.name}`
			}
		})
	})
	if (flag) {
		return code;
	} else {
		return name;
	}
}