import system from '@/common/system';
import { sign, encrypt, decrypt } from '@/common/sm2';

type RequestConfig = UniApp.RequestOptions;
type IInterceptors = {
  request?: {
    onFulfilled?: (config: RequestConfig) => RequestConfig;
    onRejected?: (error: any) => any;
  };
  response?: {
    onFulfilled?: (result: UniApp.RequestSuccessCallbackResult) => any;
    onRejected?: (error: any) => any;
  };
};

class Request {
  // 拦截器
  private readonly interceptors?: IInterceptors;

  constructor(config: { interceptors?: IInterceptors } = {}) {
    this.interceptors = config.interceptors;
  }

  /**
   * @description 统一结果处理
   */
  private resultHandle(res: Promise<any>) {
    return res;
  }

  http(_config: RequestConfig): Promise<any> {
    const requestOnFulfilled = this.interceptors?.request?.onFulfilled;
    const requestOnRejected = this.interceptors?.request?.onRejected;
    const responseOnFulfilled = this.interceptors?.response?.onFulfilled;
    const responseOnRejected = this.interceptors?.response?.onRejected;

    let config: RequestConfig = { ..._config, header: _config.header || {} };
    if (requestOnFulfilled) {
      try {
        config = requestOnFulfilled(config);
      } catch (e) {
        requestOnRejected?.(e);
      }
    }
    return new Promise((resolve, reject) => {
      xma.request({
        ...config,
        success: (result: any) => {
          if (`${result.data.code}` == 'success') {
            resolve(responseOnFulfilled?.(result.data.data) || result.data.data);
          } else if (result.data.status) {
            resolve(responseOnFulfilled?.(result) || result);
          }  else {
						xma.showModal({
							title: '温馨提示',
							content: result.data ? (result.data.msg == '失败' ? '暂无数据' : result.data.msg) : result.msg ? (result.msg == '失败' ? '暂无数据' : result.msg) : JSON.stringify(result),
							showCancel: false,
							confirmText: '关闭',
              success: () => {
								xma.navigateBack({
									delta: 1
								})
							}
						})
            reject(responseOnRejected?.(result.data.msg) || result.data.msgs);
          }
        },
        fail: (error) => {
          reject(responseOnRejected?.(error) || error);
        },
      });
    });
  }
		
  post(url: string, data: any = {}, config?: RequestConfig) {
		// const options = {
		// 	access_key: system.accessKey,
		// 	timestamp: new Date().getTime(),
		// 	request_id: new Date().getTime(),
		// 	biz_content: encrypt(JSON.stringify(data)),
		// 	// version: '',
		// 	format: 'json',
		// 	sign: 'MEYCIQD8sUj81M3vFnV3A6iJvAbA+KDD7pm0tH48ENsWlguiNQIhAMSajxzCcCPJjG/5DBcpSTmMbWVoFTlQLpUkM554zRK5'
		// }
		// console.log('原始参数：', data)
		// console.log('加密参数：', options.biz_content)
		// options['sign'] = sign(options);
    return this.resultHandle(
      this.http({
        method: 'POST',
        url,
				// header: {
				// 	'Content-Type': 'application/x-www-form-urlencoded'
				// },
				// dataType: 'json',
    //     data: options,
				data,
        ...config,
      }),
    );
  }

  get(url: string, data: any = {}, config?: RequestConfig) {
    return this.resultHandle(
      this.http({
        method: 'GET',
        url,
        data,
        ...config,
      }),
    );
  }
}

const request = new Request({
  interceptors: {
    request: {
      onFulfilled(config) {
        return config;
      },
    },
    response: {
      onFulfilled(result) {
        return result && result.data;
      },
      onRejected(error) {
        return error;
      },
    },
  },
});

export default request;
