import { KEYUTIL, KJUR , hextob64, b64tohex } from 'jsrsasign';
import { sm2 } from 'sm-crypto';

const pubKey = '04A8E8494E571D44D735B62B8DE3429F73D0100ED44243818C00B508B933638BDA2B3526699046AC8ECDDE18892A7146DF403CC05EE9672D0A86FFE8CAE1893DFA';

const priKey = '9E51874B204662F515224342FB832C6CF53EF818B5110C008E59D8312A9F2720'


export function sign(signData: object) {
	console.log('拼接参数', setParams(signData))
	let sigValueHex = sm2.doSignature(setParams(signData), priKey) // 签名
	// sigValueHex = Buffer.from(sigValueHex, 'binary').toString('base64');
	sigValueHex = arrayBufferToBase64(hex2ab(sigValueHex))
	console.log('加签参数', sigValueHex)
	return sigValueHex
}

export function encrypt(data: string) {
	const cipherMode = 1 // 1 - C1C3C2，0 - C1C2C3，默认为1
	let encryptData = sm2.doEncrypt(data, pubKey, cipherMode) // 加密结果
	// console.log('encryptData', encryptData)
	// const encryptData = Buffer.from(encryptData, 'binary').toString('base64');
	// encryptData = arrayBufferToBase64(hex2ab(encryptData))
	// encryptData = hextob64(encryptData)
	// console.log('encryptData3', encryptData)
	return encryptData
}

export function decrypt(data: string) {
	const cipherMode = 1 // 1 - C1C3C2，0 - C1C2C3，默认为1
	// const dncrypt = b64tohex(data).slice(2)
	// console.log(data)
	const dncrypt = data
	let dncryptData = sm2.doDecrypt(dncrypt, priKey, cipherMode) // 加密结果
	return dncryptData
}


/**
 * 生成签名
 * @param params 参数列表
 */
const setParams = (params: {}) => {
	const keyList = [] as any;
	const list = Object.keys(params).sort()
	list.forEach((key) => {
		keyList.push(`${key}=${params[key]}`);
	});
	return keyList.join('&');
}

// 16进制字符串转ArrayBuffer
const hex2ab = (hex) => {
  let view = new Uint8Array(hex.length / 2)
  for (let i = 0; i < hex.length; i += 2) {
    view[i / 2] = parseInt(hex.substring(i, i + 2), 16)
  }
  return view.buffer;
}

const arrayBufferToBase64 = (buffer) => {
	let binary = '';
	const bytes = new Uint8Array(buffer);
	const len = bytes.byteLength;
	for (let i = 0; i < len; i++) {
		binary += String.fromCharCode(bytes[i]);
	}
	// 对二进制字符串进行base64编码
	return window.btoa(binary);
}

	
	// test() {
	//   const url = "https://dzpztest.pubs.ylbzj.guizhou.gov.cn/engine/rest/queryRsdtPsnClctDetlList"; //keys.baseUrl + "openApi/zj/redirectPay";
	//   const body = {"certno": "520202199704155913", "pageNum": 1, "pageSize": 10, "psnNo": "52000002000000000400011816"}
	
	
	//   const params = JSON.stringify(body);
	
	//   let privateKey = "9E51874B204662F515224342FB832C6CF53EF818B5110C008E59D8312A9F2720"
	//   let publicKey = "04A8E8494E571D44D735B62B8DE3429F73D0100ED44243818C00B508B933638BDA2B3526699046AC8ECDDE18892A7146DF403CC05EE9672D0A86FFE8CAE1893DFA";
	// 	const pri = Buffer.from(privateKey, 'hex')
	//   const pub = Buffer.from(publicKey, 'hex')
	
	//   /* const hexPub = pub.toString("hex")
	//   const pubFinal = sm2.doImport(privateKey)   //sm2.parseKey(hexPub, 'public');*/
	
	
	//   let encStr = sm2.doEncrypt(params, publicKey, 1)
	//   encStr = Buffer.from(encStr, 'binary').toString('base64');
	//   console.log(encStr)
	//   let timestamp = Date.now();
	//   let paramMap = {};
	//   paramMap['biz_content'] = encStr;
	//   paramMap['access_key'] = "sgyzhmszhfwpt";
	//   paramMap['format'] = "json";
	//   paramMap['request_id'] = timestamp;
	//   paramMap['timestamp'] = timestamp;
	//   paramMap['version'] = "";
	
	//   // 生成源串
	//   let source = this.objectSort(paramMap)
	//   // 签名串,实际项目中私钥应该放在classpath下,文件名需要替换
	
	//   let sign = sm2.doSignature(source, privateKey);
	//   sign = Buffer.from(sign, 'binary').toString('base64');
	//   paramMap['sign'] = sign;
	
	//   // 获取签名
	//   // 如果是get 请求 则不需要params 参数拼接在url上 例如 /v3/pay/transactions/id/12177525012014?mchid=1230000109
	//   const formData = new URLSearchParams(paramMap);
	//   axios.post(url, formData.toString(), {
	//     headers: {
	//       'Content-Type': 'application/x-www-form-urlencoded'
	//     }
	//   }).then(response => {
	//     console.log(response);
	//   }).catch(error => {
	//     console.log(error);
	//   });
	
	// },
