export const request = ({
	url,
	data = {},
	header,
	method = "GET"
}) => {
	return new Promise((resolve, reject) => {
		header = {
			...header
		} || {
			'content-type': 'application/json'
		};
		xma.request({
			url: "https://onemoment.gywb.cn/back/sgy-gjj/gjj" + url,
			data,
			header,
			method,
			success: (res) => {
				if (res.statusCode !== 200) {
					xma.showToast({
						title: res.data.message,
						duration: 1000,
						icon: 'none',
					});
					return;
				}

				resolve(res.data)
			},
			fail: (err) => {
				reject(err)
			}
		})
	})
}