import { getToken, removeToken } from './auth';
// import domain from './domain';

export const request = ({ url, data = {}, header, method = 'GET' }) => {
  return new Promise((resolve, reject) => {
    const token = getToken();
    header = {
      /* "Client-Type": 1,
            "App-Platform-Type": "MP",
            "App-Version": (app && app.globalData.version) || '31001',
            "App-Sensor": encodeURIComponent(JSON.stringify(getApp().getPrepareAttribute())), */
      ...header,
    };
    if (token) {
      header.Authorization = 'Bearer ' + token;
    }
    xma.request({
      url: import.meta.env.VITE_APP_BASE_URL + url,
      data,
      header,
      method,
      success: (res) => {
        if (res.data.code !== 0) {
          xma.showToast({
            title: res.data.msg,
            duration: 1000,
            icon: 'none',
          });
          return;
        }
        resolve(res.data);
      },
      fail: (e) => {
        console.log('eee', e);
        reject(e);
      },
    });
  });
};
