import { request } from '../utils/request';

// 套餐详情
export function getProdDetail(data) {
  return request({
    url: `/sgyrdd/prod/getProd?prodId=${data}`,
    method: 'GET',
  });
}
// 商品详情评论数量和好评率
export function getEvalNumber(data) {
  return request({
    url: `/sgyrdd/evaluation/getEvalNumber`,
    method: 'GET',
    data,
  });
}
// 加入购物车
export function addOrder(data) {
  return request({
    url: `/sgyrdd/sgyBasket/add`,
    method: 'POST',
    data,
  });
}

// 获取购物车列表
export function getshoppingCartList(data) {
  return request({
    url: `/sgyrdd/sgyBasket/list`,
    method: 'GET',
    data,
  });
}

// 套餐详情
export function getCollect(data) {
  return request({
    url: `/sgyrdd/shop/collect?shopId=${data}`,
    method: 'GET',
  });
}
// 商家商品优惠券
export function getCouponShopList(prodId, shopId) {
  return request({
    url: `/sgyrdd/coupon/couponGoodsShopList/${shopId}/${prodId}`,
    method: 'GET',
  });
}
// 商家商品优惠券
export function receiveCoupon(data) {
  return request({
    url: `/sgyrdd/coupon/receiveCoupon`,
    method: 'GET',
    data,
  });
}

// 商家评论列表
export function getCommentList(data) {
  return request({
    url: `/sgyrdd/evaluation/page`,
    method: 'GET',
    data,
  });
}

// 评论列表数量统计和相同好评最多的评语
export function getEvalStatis(data) {
  return request({
    url: `/sgyrdd/evaluation/getEvalStatis`,
    method: 'GET',
    data,
  });
}

// 评论列表数量统计和相同好评最多的评语
export function getEvalStatisByShopId(data) {
  return request({
    url: `/sgyrdd/evaluation/getShopEvalStatis`,
    method: 'GET',
    data,
  });
}
