import { request } from '../utils/request';

// 订单列表接口
export function getOrderList(data) {
  return request({
    url: '/sgyrdd/sgyOrder/page',
    method: 'GET',
    data,
  });
}

// 订单详情接口
export function getOrderDetail(data) {
  return request({
    url: '/sgyrdd/sgyOrder/orderInfo',
    method: 'GET',
    data,
  });
}

// 删除订单 data：orderNumber
export function deleteOrderApi(data) {
  return request({
    url: '/sgyrdd/sgyOrder/del/' + data,
    method: 'POST',
  });
}

// 取消订单 data：orderNumber
export function cancelOrderApi(data) {
  return request({
    url: '/sgyrdd/sgyOrder/cancel',
    method: 'GET',
    data,
  });
}

// 商品详情接口
export function getProdDetail(data) {
  return request({
    url: '/sgyrdd/prod/getProd',
    method: 'GET',
    data,
  });
}

// 商铺详情接口
export function getShopDetail(data) {
  return request({
    url: '/sgyrdd/shop/getById',
    method: 'GET',
    data,
  });
}

// 立即支付
export function repaymentApi(data) {
  return request({
    url: '/sgyrdd/sgyOrder/repayment',
    method: 'POST',
    data,
  });
}

// 查询各类订单状态
export function sgyOrderGetStatus(data) {
  return request({
    url: '/sgyrdd/sgyOrder/getStatus',
    method: 'GET',
    data,
  });
}

// 申请退款applyForARefund
export function applyForARefundApi(data) {
  return request({
    url: '/sgyrdd/sgyOrder/afterSales/apply',
    method: 'POST',
    data,
  });
}
// 新增订单评价
export function evaluation(data) {
  return request({
    url: '/sgyrdd/evaluation/eval',
    method: 'post',
    data,
  });
}

// 查询售后详情
export function afterSale(data) {
  return request({
    url: '/sgyrdd/sgyOrder/afterSales/getInfo',
    method: 'GET',
    data,
  });
}

// 查询物流轨迹
export function getLogistics(data) {
  return request({
    url: '/sgyrdd/sgyOrder/logistics/logistics',
    method: 'POST',
    data,
  });
}

// 查询物流轨迹含地图
export function getLogisticsMap(data) {
  return request({
    url: '/sgyrdd/sgyOrder/logistics/logisticsMap',
    method: 'GET',
    data,
  });
}
