import { createSSRApp } from 'vue';
import App from './App.vue';
import store from './store';
import '@/assets/iconfont/iconfont.css'; // 引入自定义图标样式文件
import Vconsole from 'vconsole';
import './styles/flex.scss';
import { install } from './directive';
// 字体
import '@/assets/iconfont/font.css';
import Search from './components/index/Search.vue';
export function createApp() {
  const app = createSSRApp(App);
  app.component('Search', Search);
  install(app);
  const vConsole = new Vconsole();
  app.use(store, vConsole);
  return {
    app,
  };
}
