import { request } from '../../utils/request';
// 查询商品详情接口
export function getProd(data) {
  return request({
    url: `/sgyrdd/prod/getProd`,
    method: 'GET',
    data,
  });
}
// 查询商品详情接口
export function getEvalStatis(data) {
  return request({
    url: `/sgyrdd/evaluation/getEvalStatis`,
    method: 'GET',
    data,
  });
}

// 获取评价列表第一条
export function getEvaluationOne({ shopId, prodId }) {
  return request({
    url: `/sgyrdd/evaluation/page`,
    method: 'GET',
    data: {
      shopId,
      prodId,
      size: 1,
      current: 1,
    },
  });
}
// 查询商家相册列表
export function getPhoto({ shopId, prodId }) {
  return request({
    url: `/sgyrdd/photo/getPhoto`,
    method: 'GET',
    data: {
      shopId,
      prodId,
    },
  });
}
// 获取套餐价格列表
export function getMealList(data) {
  return request({
    url: `/sgyrdd/znprod/meal/list`,
    method: 'GET',
    data,
  });
}
// 查询价格日历接口
export function getPriceList(data) {
  return request({
    url: `/sgyrdd/znprod/price/list`,
    method: 'GET',
    data,
  });
}
// 查询行程活动接口
export function getItinerary(data) {
  return request({
    url: `/sgyrdd/znprod/activity/list`,
    method: 'GET',
    data,
  });
}
// 店铺信息
export function getStoreInformation(data) {
  return request({
    url: `/sgyrdd/shop/getById?shopId=${data}`,
    method: 'GET',
  });
}
