import { request } from '../utils/request';

// 新增收货地址
export async function addAddress(data) {
  return request({
    url: '/sgyrdd/useraddr/add',
    method: 'post',
    data,
  });
}
// 修改收货地址
export async function updateAddress(data) {
  return request({
    url: '/sgyrdd/useraddr/update',
    method: 'post',
    data,
  });
}
// 删除收货地址
export async function deleteAddress(addrId) {
  return request({
    url: `/sgyrdd/useraddr/delete/${addrId}`,
    method: 'POST',
  });
}
// 查询收货地址列表
export async function getAddressList() {
  return request({
    url: '/sgyrdd/useraddr/list',
    method: 'GET',
  });
}
