export function timeConversion(diffInMilliseconds) {
  // 计算总秒数
  const totalSeconds = Math.abs(Math.floor(diffInMilliseconds / 1000));

  // 计算天数、小时数和分钟数
  const days = Math.floor(totalSeconds / (24 * 60 * 60));
  const hours = Math.floor((totalSeconds % (24 * 60 * 60)) / (60 * 60));
  const minutes = Math.floor((totalSeconds % (60 * 60)) / 60);

  // 返回包含天数、小时数和分钟数的对象
  if (hours === 0) {
    return `${minutes}分钟`;
  } else if (days === 0) {
    return `${hours}小时${minutes}分钟`;
  } else {
    return `${days}天${hours}小时${minutes}分钟`;
  }
}
