// 根据经纬度计算距离，参数分别为第一点的纬度、经度；第二点的纬度、经度
/**
 *
 * @param {*} lat1 第一个纬度
 * @param {*} lng1 第一个经度
 * @param {*} lat2 第二个纬度
 * @param {*} lng2 第二个经度
 * @param {*} type 0 中文 1 英文
 * @returns
 */
export function getDistance(lat1, lng1, lat2, lng2, type = 1) {
  const R = 6371; // 地球半径，单位为千米
  const dLat = deg2rad(lat2 - lat1);
  const dLng = deg2rad(lng2 - lng1);
  const a =
    Math.sin(dLat / 2) * Math.sin(dLat / 2) +
    Math.cos(deg2rad(lat1)) * Math.cos(deg2rad(lat2)) * Math.sin(dLng / 2) * Math.sin(dLng / 2);
  const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
  const distance = R * c;
  return distance >= 1
    ? type === 0
      ? distance.toFixed(2) + '千米'
      : distance.toFixed(2) + 'km'
    : type === 1
      ? (distance * 1000).toFixed(2) + '米'
      : (distance * 1000).toFixed(2) + 'm';
}

// 将角度转换为弧度
function deg2rad(deg) {
  return deg * (Math.PI / 180);
}
/**
 * 更具图片路径返回全路径还是拼接的路径
 * @param {*} imgUrl
 * @param {*} avatarUrl
 * @returns
 */
export function addImgUrlPrefix(imgUrl, avatarUrl) {
  // 使用正则表达式检查是否是全路径
  const isFullUrl = /^https?:\/\//i.test(avatarUrl);

  // 如果不是全路径，添加 imgUrl 前缀
  if (!isFullUrl) {
    return imgUrl + avatarUrl;
  }

  // 如果是全路径，直接返回
  return avatarUrl;
}

export function addImgUrlPrefixToImages(imgUrl, imagePaths) {
  if (imagePaths !== '') {
    // 使用逗号分隔的图片路径
    const pathsArray = imagePaths.split(',');

    // 在每个路径前面添加 imgUrl 前缀
    const prefixedPaths = pathsArray.map((path) => imgUrl + path.trim());
    // 返回组装好的数组
    return prefixedPaths;
  } else {
    return [];
  }
}

// 防抖
export function debounce(func, wait) {
  let timeout;
  return function (...args) {
    clearTimeout(timeout);
    timeout = setTimeout(() => {
      func.apply(this, args);
    }, wait);
  };
}
/**
 * 跳转地图
 * @param {*} param0
 */
export function navigationSelect(item) {
  console.log(item);
  const { osName } = uni.getSystemInfoSync();
  const { name, latitude, longitude, shopAddress } = item;
  const to = {
    name: shopAddress,
    longitude,
    latitude,
  };
  const getMapScheme = (to) => {
    const u = navigator.userAgent;
    const isAndroid = osName === 'android';

    const andriodBaidu = (to) => {
      return `bdapp://map/direction?destination=name:${to.name}|latlng:${to.latitude},${to.longitude}&coord_type=gcj02&mode=driving&src=andr.jianghu.jianhao`;
    };

    const iOSBaidu = (to) => {
      return `baidumap://map/direction?destination=name:${to.name}|latlng:${to.latitude},${to.longitude}&coord_type=gcj02&mode=driving&src=ios.jianghu.jianhao`;
    };

    const andriodGaode = (to) => {
      return `amapuri://route/plan/?sourceApplication=mhc&dlat=${to.latitude}&dlon=${to.longitude}&dname=${to.name}&dev=0&t=0`;
    };

    const iOSGaode = (to) => {
      return `iosamap://path?sourceApplication=mhc&dlat=${to.latitude}&dlon=${to.longitude}&dname=${to.name}&dev=0&t=0`;
    };
    if (item.name === '百度地图') {
      if (isAndroid) {
        return andriodBaidu(to);
      } else {
        return iOSBaidu(to);
      }
    } else if (item.name === '高德地图') {
      if (isAndroid) {
        return andriodGaode(to);
      } else {
        return iOSGaode(to);
      }
    }
  };
  const a = document.createElement('a');
  document.body.appendChild(a);
  a.href = getMapScheme(to);
  a.click();
}
