import { request } from '../utils/request';

// 登录
export function getTokenUser(data) {
  return request({
    url: '/sgyrdd/auth/getToken',
    method: 'POST',
    data,
  });
}

// 分类
export function groupBuyList() {
  return request({
    url: '/sgyrdd/category/groupBuyList',
    method: 'GET',
  });
}

// 根据父级分类id查询子分类列表
export function getByParentId(data) {
  return request({
    url: `/sgyrdd/category/getByParentId`,
    method: 'GET',
    data,
  });
}

// 获取团购专区主页轮播图
export function groupImgList() {
  return request({
    url: `/sgyrdd/carousel/groupBuyList`,
    method: 'GET',
  });
}

// 附近人气美食分页
export function popularityPage(data) {
  return request({
    url: `/sgyrdd/shop/popularityPage`,
    method: 'POST',
    data,
  });
}

// 团购主页推荐分类
export function getRecommList() {
  return request({
    url: `/sgyrdd/category/getRecommList`,
    method: 'GET',
  });
}

// 附近筛选-热门地点
export function getRegion(data) {
  return request({
    url: `/sgyrdd/area/hotArea`,
    method: 'GET',
    data,
  });
}

// 附近筛选-行政区
export function administration(data) {
  return request({
    url: `/sgyrdd/area/tree`,
    method: 'GET',
    data,
  });
}

// 商家列表分页-搜索列表
export function merchantList(data) {
  return request({
    url: `/sgyrdd/shop/page`,
    method: 'POST',
    data,
  });
}

// 团购主页优惠券
export function couponMainList() {
  return request({
    url: `/sgyrdd/coupon/couponMainList`,
    method: 'GET',
  });
}

// 领取优惠券
export function receiveCoupon(data) {
  return request({
    url: `/sgyrdd/coupon/receiveCoupon`,
    method: 'POST',
    data,
  });
}
// 列表顶部优惠商品
export function prodSpecial(data) {
  return request({
    url: `/sgyrdd/prod/special`,
    method: 'GET',
    data,
  });
}

// 领券中心-分类列表
export function getCoupon() {
  return request({
    url: `/sgyrdd/dict/key/coupon_classify`,
    method: 'GET',
  });
}

// 领券中心-店铺商品列表分页
export function getShopAndProdPage(data) {
  return request({
    url: `/sgyrdd/couponShop/shopAndProdPage`,
    method: 'GET',
    data,
  });
}

// 获取指定类型轮播图
export function getByType(data) {
  return request({
    url: `/sgyrdd/carousel/getByType`,
    method: 'GET',
    data,
  });
}
