import { getTokenUser } from '../api/index';
import { sgyOrderGetStatus } from '../api/order';
import { setOrderDic } from '../utils/orderDic';

// 登录
export const signIn = () => {
  xma.showLoading({
    title: '加载中',
    mask: true,
  });
  return new Promise((resolve, reject) => {
    xma.xh.getUserProfile({
      range: ['ACCOUNT', 'MOBILE', 'CITIZEN'],
      success(info) {
        getTokenUser(info.data).then((res) => {
          xma.hideLoading();
          const token = res.data.access_token;
          const userInfo = res.data.user_info;
          xma.setStorageSync('Authorization', token);
          xma.setStorageSync('userInfo', userInfo);
          resolve();
        });
      },
    });
  });
};

export const orderStatus = () => {
  sgyOrderGetStatus().then((res) => {
    if (res.code === 0) {
      setOrderDic(res.data);
    }
  });
};
