import { request } from '../utils/request';

// 用户券统计接口
export function userCouponStatisticsApi(data) {
  return request({
    url: '/sgyrdd/coupon/getUserCouponSum',
    method: 'GET',
    data,
  });
}

// 用户券列表接口
export function myCouponListApi(data) {
  return request({
    url: '/sgyrdd/coupon/getUserCouponPage',
    method: 'GET',
    data,
  });
}

// 商铺优惠券列表接口 data：shopId
export function shopCouponList(data) {
  return request({
    url: '/sgyrdd/coupon/couponShopList/' + data,
    method: 'GET',
  });
}

// 商家商品优惠券
export function receiveCoupon(data) {
  return request({
    url: `/sgyrdd/coupon/receiveCoupon`,
    method: 'POST',
    data,
  });
}

// 优惠券使用须知
export function couponUsageNotice() {
  return request({
    url: `/sgyrdd/coupon/instructions`,
    method: 'GET',
  });
}
