import { request } from '../utils/request';

// 店铺信息
export function getStoreInformation(data) {
  return request({
    url: `/sgyrdd/shop/getById?shopId=${data}`,
    method: 'GET',
  });
}

// 店铺信息
export function groupBuyList(data) {
  return request({
    url: `/sgyrdd/prod/groupBuyList?shopId=${data}`,
    method: 'GET',
  });
}

// 商家评论列表分页
export function getEvaluationPage(data) {
  return request({
    url: `/sgyrdd/evaluation/page`,
    method: 'GET',
    data,
  });
}
// 获取商家优惠券
export function couponShopList(data) {
  return request({
    url: `/sgyrdd/coupon/couponShopList/${data}`,
    method: 'GET',
  });
}
// 评论
export function likeOrDislike(data) {
  return request({
    url: `/sgyrdd/evaluation/likeOrDislike`,
    method: 'POST',
    data,
  });
}
// 周边推荐
export function peripheryRecom(data) {
  return request({
    url: `/sgyrdd/category/peripheryRecomm`,
    method: 'GET',
    data,
  });
}
// 商家列表分页-搜索列表
export function sgyrddShopPage(data) {
  return request({
    url: `/sgyrdd/shop/page`,
    method: 'GET',
    data,
  });
}

// 获取店铺入驻分类(弹窗)
export function sgyrShopCategory() {
  return request({
    url: `/sgyrdd/category/tree`,
    method: 'GET',
  });
}

// 申请成为商家
export function applyShop(data) {
  return request({
    url: `/sgyrdd/shop/apply`,
    method: 'POST',
    data,
  });
}

// 更改申请信息
export function editShop(data) {
  return request({
    url: `/sgyrdd/shop/update`,
    method: 'POST',
    data,
  });
}

export function getShopInfoById(data) {
  return request({
    url: `/sgyrdd/shop/getShopById`,
    method: 'GET',
    data,
  });
}
