import { defineConfig } from 'vite';

import uni from '@dcloudio/vite-plugin-uni';
import AutoImport from 'unplugin-auto-import/vite';
import eslint from 'vite-plugin-eslint';
import path from 'path';
import legacy from '@vitejs/plugin-legacy';

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    uni(),
    AutoImport({
      imports: [
        'vue',
        'uni-app',
        {
          'rexma-cli': ['xma'],
        },
      ],
      dts: 'src/declaration/auto-imports.d.ts',
    }),

    eslint({
      extensions: ['js', 'ts', 'vue'],
      fix: true,
    }),

    process.env.UNI_PLATFORM === 'h5' &&
      legacy({
        targets: ['defaults', 'not IE 11'],
      }),
  ].filter(Boolean),
  resolve: {
    alias: {
      '@': path.resolve(__dirname, './src'),
    },
  }, 
  server: {
    open: true,
    // 代理配置
    proxy: {
      '/api': {
        target: 'http://test.rhhzkj.com:8080',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api/, ''),
      },
    },
  },
});
