// 页面白名单，不受拦截
const whiteList = [
	'/pages/home/index',
    '/pages/classify/index',
]

function hasPermission(url) {
	let hasLogin = uni.getStorageSync('hasLogin'); //在这可以使用token,isLogin是登录成功后在本地存储登录标识
	hasLogin = Boolean(Number(hasLogin)); //返回布尔值
	// 在白名单中或有登录判断条件可以直接跳转
	if (whiteList.indexOf(url) !== -1 || hasLogin) {
		console.log('通过')
		return true
	}
	console.log('失败')
	return false
}

uni.addInterceptor('switchTab', {
	// tabbar页面跳转前进行拦截
	invoke(e) {
		if (!hasPermission(e.url)) {
			uni.reLaunch({
				url: '/pages/account/login'
			})
			console.log('不在白名单内')
			return false
		}
		console.log('在白名单内')
		return true
	},
	success(e) {

	}
})