import { defineStore } from 'pinia'

const useUserStore = defineStore(
  'user',
  {
    state: () => ({
      userinfo: null,
      token: null
    }),
    actions: {
      login(result) {
        const { loginModel, data } = result
        this.userinfo = loginModel
        this.token = data
      },
      isLogin() {
        return this.userinfo && this.token
      },
      logout() {
        this.userinfo = null
        this.token = null
      }
    },
    persist: {
      enabled: true, // true 表示开启持久化保存
      strategies: [
        {
          storage: localStorage //表示存储在localStorage
        }
      ]
    }
  })

export default useUserStore
