import { createRouter } from 'uni-mini-router'
// 导入pages.json
import pagesJson from '../pages.json'
// 引入uni-parse-pages
import pagesJsonToRoutes from 'uni-parse-pages'
// 生成路由表
import useUserStore from '@/store/user'
const routes = pagesJsonToRoutes(pagesJson)
const router = createRouter({
  routes: [...routes] // 路由表信息
})



router.beforeEach((to, from, next) => {
  console.log(router)
  const userStore = useUserStore()
  if(to.meta) {
    console.log(to.meta)
    if (to.meta.requireAuth) {
        if (userStore.isLogin()) {
          next()
        } else {
          next({ name: 'account-login' })
        }
      } else {
        next()
      }
  } else {
    next()
  }
})

export default router
