import { createSSRApp } from "vue";
import App from "./App.vue";
import { createPinia } from 'pinia'
import piniaPersist from 'pinia-plugin-persist'
import router from "./router";
import Vconsole from "vconsole";
import 'vant/es/toast/style'
import 'vant/es/dialog/style'
import 'vant/es/notify/style'
import 'vant/es/image-preview/style'
import Header from './pages/components/Header/index.vue';

export function createApp() {
    const app = createSSRApp(App);
    const pinia = createPinia()
    pinia.use(piniaPersist)
    app.use(pinia)
    app.use(router);
    // let vConsole = new Vconsole();
    app.component('Header', Header);
    // app.use(vConsole);
    return {
        app,
    };
}

// #ifdef H5
console.log('当前基准平台：H5')
// #endif
// #ifdef H5-SGY
console.log('当前扩展平台：H5-SGY')
// #endif
