import { defineConfig, loadEnv } from 'vite';
import uni from '@dcloudio/vite-plugin-uni';

import AutoImport from 'unplugin-auto-import/vite';
import Components from 'unplugin-vue-components/vite';
import { VantResolver } from '@vant/auto-import-resolver';

import legacy from '@vitejs/plugin-legacy';
// import TransformPages from 'uni-read-pages-vite';

// https://vitejs.dev/config/
export default defineConfig(({ mode }) => {
    const env = loadEnv(mode, process.cwd())
    const { VITE_APP_ENV, VITE_APP_BASE_URL, VITE_APP_OUTDIR_FILENAME } = env
    const fileName = VITE_APP_OUTDIR_FILENAME ?? 'dist'
    return {
        plugins: [
            uni(),
            AutoImport({
                imports: [
                    'vue',
                    'uni-app',
                    'vue-router',
                    {
                        from: 'uni-mini-router',
                        imports: ['createRouter', 'useRouter', 'useRoute']
                    },
                    {
                        'rexma-cli': ['xma'],
                    },
                ],
                dts: 'src/declaration/auto-imports.d.ts',
                resolvers: [VantResolver()],
            }),
            Components({
                resolvers: [VantResolver()],
            }),
            process.env.UNI_PLATFORM === 'h5' &&
            legacy({
                targets: ['defaults', 'not IE 11'],
            }),
        ].filter(Boolean),
        // base: VITE_APP_BASE_URL,
        server: {
            host: '0.0.0.0',
            proxy: {
                '/dev-api': {
                    target: 'https://jiaxiu.gyntv.com.cn/back/jiaxiu-visit/jiaxiu-visit',
                    changeOrigin: true,
                    rewrite: (path) => path.replace(/^\/dev-api/, ""),
                    bypass: (req, res, options) => res.setHeader("x-req-proxyUr1", options.target + req.url.replace('/dev-api', ''))
                },
                '/back/ty-visit/ty-visit': {
                    target: 'https://info.gyntv.com.cn',
                    changeOrigin: true,
                    bypass: (req, res, options) => res.setHeader("x-req-proxyUr1", options.target + req.url)
                },
                '/back/jiaxiu-visit/jiaxiu-visit': {
                    target: 'https://jiaxiu.gyntv.com.cn',
                    changeOrigin: true,
                    bypass: (req, res, options) => res.setHeader("x-req-proxyUr1", options.target + req.url)
                },
                '/download': {
                    target: VITE_APP_ENV === 'production' ? 'https://info.gyntv.com.cn/' : 'https://info.gyntv.com.cn/',
                    changeOrigin: true,
                    bypass: (req, res, options) => res.setHeader("x-req-proxyUr1", options.target + req.url)
                },
                '/ws/geocoder': {
                    target: 'https://apis.map.qq.com',
                    changeOrigin: true,
                    bypass: (req, res, options) => res.setHeader('x-req-proxyUr1', options.target + req.url),
                },
            }
        },
        // build: {
        //     outDir: fileName,
        //     sourcemap: false,
        //     minify: 'terser',
        //     chunkSizeWarningLimit: 1500,
        //     terserOptions: {
        //         compress: {
        //             drop_console: true,
        //             drop_debugger: true
        //         }
        //     },
        // }
    }
});
