export function useInitScroll() {
    // 记录离开时导航条的位置
    let scrollY = ref();
    // 离开路由时的钩子函数
    onBeforeRouteLeave((to, from, next) => {
        // 记录当前的滚动条位置
        scrollY.value =
            window.pageYOffset ||
            document.documentElement.scrollTop ||
            document.body.scrollTop;
        next()
    })

    onActivated(() => {
        nextTick(() => { }).then(() => {
            window.scroll(0, scrollY.value);
        })
    })
}