import request from '@/utils/request'

/**
 * @description 专题标签列表查询
 * @param {Any} data 标签对象
 * @returns 
 */
export const selectTagsList = (data) => {
    return request({
        url: '/app/appMediaSelect/selectAppTagList',
        method: 'post',
        data: data
    })
}

/**
 * @description 专题列表查询
 * @param {Any} page 分页对象
 * @param {Any} data 标签对象
 * @returns 
 */
export const selectSubjectList = (page,data) => {
    return request({
        url: `/app/appMediaSelect/selectAppMediaByTagNamePage/${page.pageNum}/${page.pageSize}`,
        method: 'post',
        data: data
    })
}