import request from '@/utils/request'

/**
 * @description 上传图片
 * @param {File} file File对象
 * @param {Function} handleUploadProgress 上传进度回调
 * @returns 
 */
export const uploadFile = (file, handleUploadProgress) => {
    const formData = new FormData()
    formData.append("file", file)
    formData.append("systemCode", import.meta.env.VITE_APP_SYSTEM_CODE)
    return request({
        url: '/html/htmlMediaInsert/htmlSingleUpload',
        method: 'post',
        data: formData,
        onUploadProgress: handleUploadProgress,
        headers: {
            'Content-Type': 'multipart/form-data'
        }
    })
}

/**
 * @description 查询类型数据
 * @returns 
 */
export const selectTypeList = () => {
    const data = {
        materialType: 3
    }
    return request({
        url: '/html/htmlMediaSelect/selectHtmlClassifyList',
        method: 'post',
        data: data
    })
}

/**
 * @description 查询来源数据
 * @param {Number} sourceType 1.来源类型 2.来源渠道
 * @returns 
 */
export const selectSourceList = (sourceType) => {
    const data = { sourceType }
    return request({
        url: '/html/htmlMediaSelect/selectHtmlSourceList',
        method: 'post',
        data: data
    })
}

/**
 * @description 查询标签数据
 * @returns 
 */
export const selectTagsList = () => {
    const data = {}
    return request({
        url: `/html/htmlMediaSelect/treeHtmlTagData/${import.meta.env.VITE_APP_SYSTEM_CODE}`,
        method: 'post',
        data: data
    })
}

/**
 * @description 精细查询图组列表
 * @param {Any} page 分页对象
 * @param {Any} data 图组对象
 * @returns 
 */
export const selectFinePictureList = (page, data) => {
    return request({
        url: `/app/appMediaSelect/selectAppFineCatalogList/${page.pageNum}/${page.pageSize}`,
        method: 'post',
        data: data
    })
}

/**
 * @description 广泛查询图组列表
 * @param {Any} page 分页对象
 * @param {Any} data 图组对象
 * @returns 
 */
export const selectCoarsePictureList = (page, data) => {
    return request({
        url: `/app/appMediaSelect/selectAppCatalogList/${page.pageNum}/${page.pageSize}`,
        method: 'post',
        data: data
    })
}

/**
 * @description 我的图组列表
 * @param {Any} page 分页对象
 * @param {Any} data 图组对象
 * @returns 
 */
export const selectMinePictureList = (page, data) => {
    return request({
        url: `/app/appMediaSelect/selectAppMaterialRetrievalList/${page.pageNum}/${page.pageSize}`,
        method: 'post',
        data: data
    })
}

/**
 * @description 我的收藏列表
 * @param {Any} page 分页对象
 * @param {Any} data 图组对象
 * @returns 
 */
export const selectCollectPictureList = (page, data) => {
    return request({
        url: `/app/appMediaSelect/selectAppPersonMaterialList/${page.pageNum}/${page.pageSize}`,
        method: 'post',
        data: data
    })
}

/**
 * @description 发布图组
 * @param {Any} data 图组对象
 * @returns 
 */
export const publishPicture = ( data) => {
    return request({
        url: '/app/appMediaUpdate/updateAppCollect',
        method: 'post',
        data: data
    })
}



/**
 * @description 新增图组
 * @param {Any} data 图组对象
 * @returns 
 */
export const insertPicture = (data) => {
    return request({
        url: '/html/htmlMediaInsert/htmlInsertImageCatalog',
        method: 'post',
        data: data
    })
}

/**
 * @description 新增图组地址
 * @param {Any} data 图组地址列表
 * @returns 
 */
export const insertPictureUrl = (data) => {
    return request({
        url: '/html/htmlMediaInsert/htmlBatchInsertEnclosure',
        method: 'post',
        data: data
    })
}

/**
 * @description 删除图组
 * @param {Any} data 删除信息对象
 * @returns 
 */
export const deleteAppCatalog = (data) => {
    return request({
        url: '/app/appMediaDelete/deleteAppCatalog',
        method: 'post',
        data: data
    })
}

/**
 * @description 查询图组详情
 * @param {Number} id 图组id
 * @returns 
 */
export const selectPictureById = (id) => {
    return request({
        url: `/app/appMediaSelect/selectAppByMaterialId/${id}`,
        method: 'post',
        data: {}
    })
}

/**
 * @description 查询组织
 * @param {Any} data 组织对象
 * @returns 
 */
export const selectOrganizeList = (data) => {
    data.moduleCode = import.meta.env.VITE_APP_VISITOR_CODE
    return request({
        url: '/html/htmlMediaSelect/selectHtmlOrganizeList',
        method: 'post',
        data: data
    })
}

