import request from '@/utils/request'

/**
 * @description 组织列表查询
 * @param {Any} data 标签对象
 * @returns 
 */
export const selectOrganizeList = (data) => {
    return request({
        url: '/app/appMediaSelect/selectAppOrganizeList',
        method: 'post',
        data: data
    })
}

/**
 * @description 用户组织列表查询（全）
 * @param {Any} data 标签对象
 * @returns 
 */
export const selectAppUserOrganizeList = (data) => {
    return request({
        url: '/app/appMediaSelect/selectAppUserOrganizeList',
        method: 'post',
        data: data
    })
}

/**
 * @description 专区列表查询
 * @param {Any} page 分页对象
 * @param {Any} data 图组对象
 * @returns 
 */
export const selectPrefecturetList = (page,data) => {
    return request({
        url: `/app/appMediaSelect/selectAppMediaByOrganIdPage/${page.pageNum}/${page.pageSize}`,
        method: 'post',
        data: data
    })
}