import request from '@/utils/request'

/**
 * @description 分类类型列表查询
 * @param {Any} page 分页对象
 * @param {Any} data 图组对象
 * @returns 
 */
export const selectClassifyTypeList = (page,data) => {
    return request({
        url: `/app/appMediaSelect/getAppClassifyPageInfo/${page.pageNum}/${page.pageSize}`,
        method: 'post',
        data: data
    })
}


/**
 * @description 分类列表查询
 * @param {Any} page 分页对象
 * @param {Any} data 图组对象
 * @returns 
 */
export const selectClassifyList = (page,data) => {
    return request({
        url: `/app/appMediaSelect/selectAppMediaByTypeClassifyPage/${page.pageNum}/${page.pageSize}`,
        method: 'post',
        data: data
    })
}