# 小程序平台模板 vue3

## 安装依赖
```
yarn install
```

### 本地服务
```
yarn start
```

### 小程序平台打包
```
yarn build
```

## 默认安装的 UI 库

[wot-design-uni](https://wot-design-uni.netlify.app/component/button.html)

### 自定义爽贵阳条件编译平台 H5-SGY

#### 1.配置扩展平台

```
//package.json
"uni-app": {
    "scripts": {
      "h5-sgy": {
        "title": "爽贵阳平台",
        "env": {
          "UNI_PLATFORM": "h5"
        },
        "define": {
          "H5-SGY": true
        }
      }
    }
  }
```

#### 2.修改启动命令

```
//package.json
"scripts": {
  "start": "uni -p h5-sgy",
  "build": "uni build -p h5-sgy",
  "start:platform": "rexma start",
  "build:platform": "rexma build"
}
```

#### 3.使用方式参考 main.js

```
// #ifdef H5
console.log('当前基准平台：H5')
// #endif
// #ifdef H5-SGY
console.log('当前扩展平台：H5-SGY')
// #endif

```

##### 注意：H5-SGY 条件编译是基于 H5 条件编译进行扩展，H5-SGY 条件编译和 H5 条件编译会同时生效。若需要仅 H5 条件编译生效，请指定运行或打包平台为 H5。
